define([
    'underscore',
    'backbone',
    'marionette',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-by-date-collection',
    'text!modules/new-appointment-request/views/direct/preferred-date/templates/closest-dates.html',
    'modules/new-appointment-request/views/direct/preferred-date/date-collapsible',
],
function(
    _,
    Backbone,
    Marionette,
    TimeSlotsByDateCollection,
    template,
    DateCollapsibleView
) {
    'use strict';

    // reduces rendering time with prerendered collapsible template;
    // given this.timeSlotsCollection and this.model (form model),
    // create this.collection filtered by date and show child views
    return Marionette.CompositeView.extend({
        template: template,
        childViewContainer: '.available-dates',
        childView: DateCollapsibleView,
        initialize: function(options) {
            if (_.isUndefined(this.collection)) {
                this._initializeAndFilterCollection(options.timeSlotsByDateCollection);
            }
        },
        // given an array of objects with {
        // date: string,
        // timeSlots: Backbone timeSlotsCollection
        // }
        // create this.collection of available times on closest available dates,
        // grouped by date
        _initializeAndFilterCollection: function(timeSlotsByDateCollection) {
            var timeSlotsByDate = timeSlotsByDateCollection.models;
            var collection = new TimeSlotsByDateCollection();

            var groupedTimeSlots = timeSlotsByDate;
            var preferredDate = this.model.get('desiredDate');
            var groupTimeSlotsLength = 3;
            var dateLength = 10;

            var preferredDateGroup;
            var preferredDateIndex;
            var startDateIndex;
            var endDateIndex;
            var preferredDateInMilliseconds;

            this.collection = collection;

            if (groupedTimeSlots.length > groupTimeSlotsLength) {
                // get the index where the preferred date would be inserted
                preferredDateGroup = new Backbone.Model({date: preferredDate.substring(0, dateLength)});
                preferredDateIndex = _.sortedIndexBy(groupedTimeSlots, preferredDateGroup, function(dateGroup) {
                    var date = new Date(dateGroup.get('date'));
                    date.setHours(0, 0, 0, 0);

                    return date;
                });

                // get up to three dates before and three after the preferred date
                startDateIndex = preferredDateIndex - groupTimeSlotsLength <= 0 ?
                    0 :
                    preferredDateIndex - groupTimeSlotsLength;

                endDateIndex = preferredDateIndex + groupTimeSlotsLength >= groupedTimeSlots.length ?
                    groupedTimeSlots.length :
                    preferredDateIndex + groupTimeSlotsLength;

                groupedTimeSlots = groupedTimeSlots.slice(startDateIndex, endDateIndex);

                // sort by the absolute difference to the preferredDate
                preferredDateInMilliseconds = new Date(preferredDate).getTime();
                groupedTimeSlots = _.sortBy(groupedTimeSlots, function(dateGroup) {
                    var date = new Date(dateGroup.get('date'));
                    var diff;

                    date.setHours(0, 0, 0, 0);
                    diff = date.getTime() - preferredDateInMilliseconds;

                    // tie-breaker; when two dates have the same absolute difference
                    // sort later dates after earlier dates by adding one millsecond
                    diff += (diff > 0 ? 1 : 0);

                    return Math.abs(diff);
                });

                groupedTimeSlots.length = 3;
            }

            // add dates to the collection, which has a comparator to ensure chronological order
            this.collection.add(groupedTimeSlots);
        },

        onDomRefresh: function() {
            this.$el.trigger('create');
            this.focusOnLegend();
        },
        focusOnLegend: function() {
            // iOS Safari unable to focus on legend, focusing on text in legend instead
            this.$el.find('legend span[tabindex]').focus();
        },
    });
});
